/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.AttributeInfo;
import dioscuri.module.cpu32.ConstantPoolInfo;
import dioscuri.module.cpu32.FieldInfo;
import dioscuri.module.cpu32.MethodInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ClassFile {
    private int magic;
    private int minorVersion;
    private int majorVersion;
    private int constantPoolCount;
    private ConstantPoolInfo[] constantPool;
    private Map<ConstantPoolInfo, Integer> constantPoolMap;
    private int accessFlags;
    private int thisClass;
    private int superClass;
    private int interfacesCount;
    private int[] interfaces;
    private int fieldsCount;
    private FieldInfo[] fields;
    private int methodsCount;
    private MethodInfo[] methods;
    private int attributesCount;
    private AttributeInfo[] attributes;
    public static final short PUBLIC = 1;
    public static final short FINAL = 16;
    public static final short SUPER = 32;
    public static final short INTERFACE = 512;
    public static final short ABSTRACT = 1024;
    public static final int MAX_CONSTANT_POOL_SIZE = 65536;

    public void read(DataInputStream dataInputStream) throws IOException {
        this.readMagic(dataInputStream);
        this.readVersion(dataInputStream);
        this.readConstantPool(dataInputStream);
        this.readAccessFlags(dataInputStream);
        this.readThisClass(dataInputStream);
        this.readSuperClass(dataInputStream);
        this.readInterfaces(dataInputStream);
        this.readFields(dataInputStream, this.constantPool);
        this.readMethods(dataInputStream, this.constantPool);
        this.readAttributes(dataInputStream, this.constantPool);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        this.writeMagic(dataOutputStream);
        this.writeVersion(dataOutputStream);
        this.writeConstantPool(dataOutputStream);
        this.writeAccessFlags(dataOutputStream);
        this.writeThisClass(dataOutputStream);
        this.writeSuperClass(dataOutputStream);
        this.writeInterfaces(dataOutputStream);
        this.writeFields(dataOutputStream);
        this.writeMethods(dataOutputStream);
        this.writeAttributes(dataOutputStream);
    }

    public void update() {
        this.minorVersion = 0;
        this.majorVersion = 46;
    }

    public String[] getMethodNames() {
        String[] stringArray = new String[this.methodsCount];
        for (int i = 0; i < this.methodsCount; ++i) {
            int n = this.methods[i].getNameIndex();
            stringArray[i] = ((ConstantPoolInfo.Utf8Info)this.constantPool[n]).getBytes();
        }
        return stringArray;
    }

    public int[] getMethodCode(String string) {
        MethodInfo methodInfo = this.getMethodInfo(string);
        return methodInfo.getCode();
    }

    public void setMethodCode(String string, int[] nArray) {
        this.setMethodCode(string, nArray, nArray.length);
    }

    public void setMethodCode(String string, int[] nArray, int n) {
        MethodInfo methodInfo = this.getMethodInfo(string);
        methodInfo.setCode(nArray, n, this);
    }

    public AttributeInfo.CodeAttribute.ExceptionEntry[] getMethodExceptionTable(String string) {
        MethodInfo methodInfo = this.getMethodInfo(string);
        return methodInfo.getExceptionTable();
    }

    public void setMethodExceptionTable(String string, AttributeInfo.CodeAttribute.ExceptionEntry[] exceptionEntryArray) {
        this.setMethodExceptionTable(string, exceptionEntryArray, exceptionEntryArray.length);
    }

    public void setMethodExceptionTable(String string, AttributeInfo.CodeAttribute.ExceptionEntry[] exceptionEntryArray, int n) {
        MethodInfo methodInfo = this.getMethodInfo(string);
        methodInfo.setExceptionTable(exceptionEntryArray, n, this);
    }

    public String getClassName() {
        if (this.constantPool[this.thisClass].getTag() != 7) {
            throw new ClassFormatError("thisClass points to non-class constant pool entry");
        }
        int n = ((ConstantPoolInfo.ClassInfo)this.constantPool[this.thisClass]).getNameIndex();
        if (this.constantPool[n].getTag() != 1) {
            throw new ClassFormatError("thisClass constant pool entry points to non-utf8 constant pool entry");
        }
        return ((ConstantPoolInfo.Utf8Info)this.constantPool[n]).getBytes().replace('/', '.');
    }

    public void setClassName(String string) {
        if (this.constantPool[this.thisClass].getTag() != 7) {
            throw new ClassFormatError("thisClass points to non-class constant pool entry");
        }
        int n = ((ConstantPoolInfo.ClassInfo)this.constantPool[this.thisClass]).getNameIndex();
        if (this.constantPool[n].getTag() != 1) {
            throw new ClassFormatError("thisClass constant pool entry points to non-utf8 constant pool entry");
        }
        this.constantPool[n] = new ConstantPoolInfo.Utf8Info(string.replace('.', '/'));
    }

    public int addToConstantPool(Object object) {
        ConstantPoolInfo constantPoolInfo = null;
        if (object instanceof Field) {
            Field field = (Field)object;
            String string = ClassFile.getDescriptor(field.getType());
            ConstantPoolInfo.Utf8Info utf8Info = new ConstantPoolInfo.Utf8Info(field.getName());
            int n = this.addToConstantPool(utf8Info);
            ConstantPoolInfo.Utf8Info utf8Info2 = new ConstantPoolInfo.Utf8Info(string);
            int n2 = this.addToConstantPool(utf8Info2);
            ConstantPoolInfo.NameAndTypeInfo nameAndTypeInfo = new ConstantPoolInfo.NameAndTypeInfo(n, n2);
            int n3 = this.addToConstantPool(nameAndTypeInfo);
            Class<?> clazz = ((Field)object).getDeclaringClass();
            int n4 = this.addToConstantPool(clazz);
            constantPoolInfo = new ConstantPoolInfo.FieldRefInfo(n4, n3);
        } else if (object instanceof Method) {
            Method method = (Method)object;
            Class<?>[] classArray = method.getParameterTypes();
            StringBuffer stringBuffer = new StringBuffer("(");
            for (int i = 0; i < classArray.length; ++i) {
                stringBuffer.append(ClassFile.getDescriptor(classArray[i]));
            }
            stringBuffer.append(")");
            stringBuffer.append(ClassFile.getDescriptor(method.getReturnType()));
            String string = stringBuffer.toString();
            ConstantPoolInfo.Utf8Info utf8Info = new ConstantPoolInfo.Utf8Info(method.getName());
            int n = this.addToConstantPool(utf8Info);
            ConstantPoolInfo.Utf8Info utf8Info3 = new ConstantPoolInfo.Utf8Info(string);
            int n5 = this.addToConstantPool(utf8Info3);
            ConstantPoolInfo.NameAndTypeInfo nameAndTypeInfo = new ConstantPoolInfo.NameAndTypeInfo(n, n5);
            int n6 = this.addToConstantPool(nameAndTypeInfo);
            Class<?> clazz = method.getDeclaringClass();
            int n7 = this.addToConstantPool(clazz);
            constantPoolInfo = clazz.isInterface() ? new ConstantPoolInfo.InterfaceMethodRefInfo(n7, n6) : new ConstantPoolInfo.MethodRefInfo(n7, n6);
        } else if (object instanceof Class) {
            Class clazz = (Class)object;
            String string = clazz.getName().replace('.', '/');
            constantPoolInfo = new ConstantPoolInfo.Utf8Info(string);
            int n = this.addToConstantPool(constantPoolInfo);
            constantPoolInfo = new ConstantPoolInfo.ClassInfo(n);
        } else if (object instanceof String) {
            constantPoolInfo = new ConstantPoolInfo.Utf8Info((String)object);
            int n = this.addToConstantPool(constantPoolInfo);
            constantPoolInfo = new ConstantPoolInfo.StringInfo(n);
        } else if (object instanceof Integer) {
            constantPoolInfo = new ConstantPoolInfo.IntegerInfo((Integer)object);
        } else if (object instanceof Float) {
            constantPoolInfo = new ConstantPoolInfo.FloatInfo(((Float)object).floatValue());
        } else if (object instanceof Long) {
            constantPoolInfo = new ConstantPoolInfo.LongInfo((Long)object);
        } else if (object instanceof Double) {
            constantPoolInfo = new ConstantPoolInfo.DoubleInfo((Double)object);
        } else if (object instanceof ConstantPoolInfo) {
            constantPoolInfo = (ConstantPoolInfo)object;
        } else {
            throw new IllegalArgumentException("Invalid Class To Add To Constant Pool");
        }
        int n = this.searchConstantPool(constantPoolInfo);
        if (n > 0) {
            return n;
        }
        if (constantPoolInfo instanceof ConstantPoolInfo.DoubleInfo || constantPoolInfo instanceof ConstantPoolInfo.LongInfo) {
            this.constantPool[this.constantPoolCount] = constantPoolInfo;
            this.constantPoolMap.put(constantPoolInfo, new Integer(this.constantPoolCount));
            this.constantPool[this.constantPoolCount + 1] = constantPoolInfo;
            this.constantPoolCount += 2;
            return this.constantPoolCount - 2;
        }
        this.constantPool[this.constantPoolCount] = constantPoolInfo;
        this.constantPoolMap.put(constantPoolInfo, new Integer(this.constantPoolCount));
        ++this.constantPoolCount;
        return this.constantPoolCount - 1;
    }

    public int getMethodMaxStack(String string) {
        MethodInfo methodInfo = this.getMethodInfo(string);
        return methodInfo.getMaxStack();
    }

    public int getMethodMaxLocals(String string) {
        MethodInfo methodInfo = this.getMethodInfo(string);
        return methodInfo.getMaxLocals();
    }

    protected String getConstantPoolFieldDescriptor(int n) {
        ConstantPoolInfo constantPoolInfo = this.constantPool[n];
        n = ((ConstantPoolInfo.FieldRefInfo)constantPoolInfo).getNameAndTypeIndex();
        constantPoolInfo = this.constantPool[n];
        n = ((ConstantPoolInfo.NameAndTypeInfo)constantPoolInfo).getDescriptorIndex();
        constantPoolInfo = this.constantPool[n];
        return ((ConstantPoolInfo.Utf8Info)constantPoolInfo).getBytes();
    }

    protected int getFieldLength(String string) {
        return this.getFieldLength(string.charAt(0));
    }

    private int getFieldLength(char c) {
        switch (c) {
            case 'V': {
                return 0;
            }
            case 'B': 
            case 'C': 
            case 'F': 
            case 'I': 
            case 'L': 
            case 'S': 
            case 'Z': 
            case '[': {
                return 1;
            }
            case 'D': 
            case 'J': {
                return 2;
            }
        }
        throw new IllegalStateException();
    }

    protected String getConstantPoolUtf8(int n) {
        return ((ConstantPoolInfo.Utf8Info)this.constantPool[n]).getBytes();
    }

    protected String getConstantPoolMethodDescriptor(int n) {
        ConstantPoolInfo constantPoolInfo = this.constantPool[n];
        n = ((ConstantPoolInfo.MethodRefInfo)constantPoolInfo).getNameAndTypeIndex();
        constantPoolInfo = this.constantPool[n];
        n = ((ConstantPoolInfo.NameAndTypeInfo)constantPoolInfo).getDescriptorIndex();
        constantPoolInfo = this.constantPool[n];
        return ((ConstantPoolInfo.Utf8Info)constantPoolInfo).getBytes();
    }

    protected int getMethodStackDelta(String string) {
        int n = this.getMethodArgLength(string);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != ')') continue;
            return n - this.getFieldLength(string.charAt(i + 1));
        }
        throw new IllegalStateException("Invalid method descriptor");
    }

    int getMethodArgLength(String string) {
        int n = 0;
        boolean bl = false;
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '[': {
                    while ((c = string.charAt(++i)) == '[') {
                    }
                    if (c != 'L') {
                        ++n;
                        continue block7;
                    }
                }
                case 'L': {
                    while (string.charAt(++i) != ';') {
                    }
                    ++n;
                    continue block7;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++n;
                    continue block7;
                }
                case 'D': 
                case 'J': {
                    n += 2;
                    continue block7;
                }
                case ')': {
                    return n;
                }
            }
        }
        throw new IllegalStateException("Invalid method descriptor");
    }

    private static String getDescriptor(Class<?> clazz) {
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        if (clazz.isPrimitive()) {
            if (clazz.equals(Byte.TYPE)) {
                return "B";
            }
            if (clazz.equals(Character.TYPE)) {
                return "C";
            }
            if (clazz.equals(Double.TYPE)) {
                return "D";
            }
            if (clazz.equals(Float.TYPE)) {
                return "F";
            }
            if (clazz.equals(Integer.TYPE)) {
                return "I";
            }
            if (clazz.equals(Long.TYPE)) {
                return "J";
            }
            if (clazz.equals(Short.TYPE)) {
                return "S";
            }
            if (clazz.equals(Boolean.TYPE)) {
                return "Z";
            }
            if (clazz.equals(Void.TYPE)) {
                return "V";
            }
        } else {
            return 'L' + clazz.getName().replace('.', '/') + ';';
        }
        throw new IllegalStateException("They added a primitive!!! Is it unsigned!!! " + clazz.getName());
    }

    private int searchConstantPool(ConstantPoolInfo constantPoolInfo) {
        Integer n = this.constantPoolMap.get(constantPoolInfo);
        if (n != null) {
            return n;
        }
        return -1;
    }

    private MethodInfo getMethodInfo(String string) {
        for (int i = 0; i < this.methodsCount; ++i) {
            int n = this.methods[i].getNameIndex();
            if (this.constantPool[n].getTag() != 1 || !((ConstantPoolInfo.Utf8Info)this.constantPool[n]).getBytes().equals(string)) continue;
            return this.methods[i];
        }
        return null;
    }

    private void readMagic(DataInputStream dataInputStream) throws IOException {
        this.magic = dataInputStream.readInt();
    }

    private void writeMagic(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.magic);
    }

    private void readVersion(DataInputStream dataInputStream) throws IOException {
        this.minorVersion = dataInputStream.readUnsignedShort();
        this.majorVersion = dataInputStream.readUnsignedShort();
    }

    private void writeVersion(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.minorVersion);
        dataOutputStream.writeShort(this.majorVersion);
    }

    private void readConstantPool(DataInputStream dataInputStream) throws IOException {
        this.constantPoolCount = dataInputStream.readUnsignedShort();
        this.constantPool = new ConstantPoolInfo[65536];
        this.constantPoolMap = new HashMap<ConstantPoolInfo, Integer>();
        for (int i = 1; i < this.constantPoolCount; ++i) {
            ConstantPoolInfo constantPoolInfo;
            this.constantPool[i] = constantPoolInfo = ConstantPoolInfo.construct(dataInputStream);
            this.constantPoolMap.put(constantPoolInfo, new Integer(i));
            if (!(this.constantPool[i] instanceof ConstantPoolInfo.DoubleInfo) && !(this.constantPool[i] instanceof ConstantPoolInfo.LongInfo)) continue;
            this.constantPool[++i] = this.constantPool[i - 1];
        }
    }

    private void writeConstantPool(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.constantPoolCount);
        for (int i = 1; i < this.constantPoolCount; ++i) {
            this.constantPool[i].write(dataOutputStream);
            if (!(this.constantPool[i] instanceof ConstantPoolInfo.DoubleInfo) && !(this.constantPool[i] instanceof ConstantPoolInfo.LongInfo)) continue;
            ++i;
        }
    }

    private void readAccessFlags(DataInputStream dataInputStream) throws IOException {
        this.accessFlags = dataInputStream.readUnsignedShort();
    }

    private void writeAccessFlags(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.accessFlags);
    }

    private void readThisClass(DataInputStream dataInputStream) throws IOException {
        this.thisClass = dataInputStream.readUnsignedShort();
    }

    private void writeThisClass(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.thisClass);
    }

    private void readSuperClass(DataInputStream dataInputStream) throws IOException {
        this.superClass = dataInputStream.readUnsignedShort();
    }

    private void writeSuperClass(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.superClass);
    }

    private void readInterfaces(DataInputStream dataInputStream) throws IOException {
        this.interfacesCount = dataInputStream.readUnsignedShort();
        this.interfaces = new int[this.interfacesCount];
        for (int i = 0; i < this.interfacesCount; ++i) {
            this.interfaces[i] = dataInputStream.readUnsignedShort();
        }
    }

    private void writeInterfaces(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.interfacesCount);
        for (int i = 0; i < this.interfacesCount; ++i) {
            dataOutputStream.writeShort(this.interfaces[i]);
        }
    }

    private void readFields(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
        this.fieldsCount = dataInputStream.readUnsignedShort();
        this.fields = new FieldInfo[this.fieldsCount];
        for (int i = 0; i < this.fieldsCount; ++i) {
            this.fields[i] = new FieldInfo(dataInputStream, constantPoolInfoArray);
        }
    }

    private void writeFields(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.fieldsCount);
        for (int i = 0; i < this.fieldsCount; ++i) {
            this.fields[i].write(dataOutputStream);
        }
    }

    private void readMethods(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
        this.methodsCount = dataInputStream.readUnsignedShort();
        this.methods = new MethodInfo[this.methodsCount];
        for (int i = 0; i < this.methodsCount; ++i) {
            this.methods[i] = new MethodInfo(dataInputStream, constantPoolInfoArray);
        }
    }

    private void writeMethods(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.methodsCount);
        for (int i = 0; i < this.methodsCount; ++i) {
            this.methods[i].write(dataOutputStream);
        }
    }

    private void readAttributes(DataInputStream dataInputStream, ConstantPoolInfo[] constantPoolInfoArray) throws IOException {
        this.attributesCount = dataInputStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i] = AttributeInfo.construct(dataInputStream, constantPoolInfoArray);
        }
    }

    private void writeAttributes(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.attributesCount);
        for (int i = 0; i < this.attributesCount; ++i) {
            this.attributes[i].write(dataOutputStream);
        }
    }
}

